#include "function.h"
#include <malloc.h>

int before_sequence = 0;
int row_count = 0;

// remove quotes
char* RemoveQuotes(const char* str){
    size_t len = strlen(str);
    if (len<2 || str[0] != '"' || str[len-1] != '"'){
        return str;
    }
    char* result = malloc(len-1);
    if (result == NULL){
        printf("Memory allocation failed.\n");
        return NULL;
    }
    strncpy(result, str+1, len-2);
    result[len-2] = '\0';

    return result;

}

// str upper
const char* StrUpper(char str[]){
    int i = 0;
    while(str[i]){
        if(str[i]>='a' && str[i]<='z'){
            str[i]=str[i]-32;
        }
        i++;
    }
}

// conn, conf parser
ConfigInfo* ConfigParser(char* path){
    char conf_file_path[PATH_LEN] = {0,};
    snprintf(conf_file_path, sizeof(conf_file_path), "/home/oracle/CLionProjects/extract_project/%s.conf", path);

    ConfigInfo *config_info = malloc(sizeof(ConfigInfo));
    struct qlisttbl_s* tbl = qconfig_parse_file(NULL, conf_file_path, '=');

    // db conn, extraction schema info
    char* db_conn = RemoveQuotes(tbl->getstr(tbl,"DBCONN", false));
    char* extraction_schema = RemoveQuotes(tbl->getstr(tbl,"EXTRACTION_TARGET",false));

    if (db_conn == NULL || extraction_schema == NULL){
        printf("-- Check : configure file has missing value.\n");
        tbl->free(tbl);
        return NULL;

    }else{
        strncpy(config_info->db_conn, db_conn, PATH_LEN);
        int extraction_schema_len = strlen(extraction_schema);
        char* extraction_schema_copy = malloc(sizeof(char)*(extraction_schema_len+1));
        strncpy(extraction_schema_copy, extraction_schema, extraction_schema_len);
        free(extraction_schema_copy);

    }

    // log level
    char* log_level = RemoveQuotes(tbl-> getstr(tbl,"LOG_LEVEL", false));
    if (strcmp(log_level, "TRACE") == 0 || strcmp(log_level, "DEBUG") == 0 || strcmp(log_level, "INFO") == 0) {
        strncpy(config_info->log_level, log_level, LOG_LEVEL_LEN);
    }else {
        tbl->free(tbl);
        printf("--Check config file: missing Log level option.\n");
        return NULL;
    }

    // log backup
    char* log_backup = RemoveQuotes(tbl->getstr(tbl, "LOG_BACKUP", false));
    if (log_backup != NULL && (strcmp(log_backup, "NOT_BACKUP") == 0 ||
                               strcmp(log_backup, "ROTATE_BACKUP") == 0 ||
                               strcmp(log_backup, "DAILY_ROTATE_BACKUP") == 0)) {
        strncpy(config_info->log_backup, log_backup, LOG_BACKUP_LEN);
    } else {
        tbl->free(tbl);
        printf("--Check config file: missing or invalid Log Backup option.\n");
        return NULL;
    }

    // log path, tracing path
    char* log_path = RemoveQuotes(tbl->getstr(tbl,"LOG_PATH", false));
    if (log_path == NULL){
        printf("DEFAULT_LOG_PATH\n");
        strncpy(config_info->log_path, DEFAULT_LOG_PATH, PATH_LEN);
    }else{
        strncpy(config_info->log_path, log_path, PATH_LEN);
    }

    char* tracing_path = tbl->getstr(tbl,"TRACING_PATH",false);
    if (tracing_path == NULL){
        printf("DEFAULT_TRACING_PATH\n");
        strncpy(config_info->tracing_path, DEFAULT_TRACING_PATH, PATH_LEN);
    }else{
        strncpy(config_info->tracing_path, tracing_path, PATH_LEN);
    }
    tbl->free(tbl);
    return config_info;
}
DbConnInfo* ConnectParser(char* path){
    char conn_file_path[PATH_LEN] = {0,};
    snprintf(conn_file_path, sizeof(conn_file_path), "/home/oracle/CLionProjects/extract_project/%s.conn", path);

    DbConnInfo *conn_info = malloc(sizeof(DbConnInfo));
    qlisttbl_t *tbl = qconfig_parse_file(NULL, conn_file_path, '=');

    char* ip = RemoveQuotes(tbl->getstr(tbl,"IP", false));
    char* port = RemoveQuotes(tbl->getstr(tbl,"PORT", false));
    char* dbname = RemoveQuotes(tbl->getstr(tbl,"DBNAME", false));
    char* username = RemoveQuotes(tbl->getstr(tbl,"USERNAME", false));
    char* password = RemoveQuotes(tbl->getstr(tbl,"PASSWORD", false));

    if (ip == NULL || port == NULL || dbname == NULL || username == NULL || password == NULL) {
        printf("-- Check : connection file has missing value.\n");
        tbl->free(tbl);
        return NULL;

    }else{
        strncpy(conn_info->ip, ip, IP_LEN);
        strncpy(conn_info->port, port, PORT_LEN);
        strncpy(conn_info->dbname, dbname, DBNAME_LEN);
        strncpy(conn_info->username, username, USERNAME_LEN);
        strncpy(conn_info->password, password, PASSWORD_LEN);

        tbl->free(tbl);
        return conn_info;
    }
}

// create ip:port/db
char* CreateIpPort(const char* ip, const char* port, const char* dbname) {
    char *ip_port = MallocAllocation(IP_PORT_LEN);

    snprintf(ip_port, IP_PORT_LEN, "%s:%s/%s", ip, port, dbname);
    return ip_port;
}

// check supplemental logging
bool CheckSupplementalLog(OCI_Connection* cn){
    OCI_Statement* st = OCI_StatementCreate(cn);
    OCI_ExecuteStmtFmt(st, SUPPLEMENTAL_LOG);
    OCI_Resultset* rs = OCI_GetResultset(st);

    while(OCI_FetchNext(rs)){
        const char* supplemental_status = OCI_GetString(rs, 1);
        if (strncmp(supplemental_status, "YES", strlen(supplemental_status)) == 0){
            printf("Supplemental Logging on.\n");
            return true;
        }else {
            printf("---Check : Alter database add supplemental log data.\n");
            return false;
        }
    }
}

// malloc
void* MallocAllocation(size_t size) {
    void* pointer = malloc(size);
    if (!pointer) {
        printf("Memory allocation failed\n");
        exit(EXIT_FAILURE);
    }
    return pointer;
}

/*
// config info table list
void AddTableList(ConfigSet config_set, OCI_Connection* cn){
    OCI_Statement *st = OCI_StatementCreate(cn);
    OCI_Resultset *rs;

    qlisttbl_t *tbl = qlisttbl(QLISTTBL_THREADSAFE);
    char* table_list_query = malloc(TABLE_LIST_LEN);
    ConfigInfo *config_info = config_set.config_info;

    // make query
    StrUpper(config_set.conn_info->username);
    snprintf(table_list_query, TABLE_LIST_LEN, TABLE_LIST, config_set.conn_info->username);
    OCI_ExecuteStmtFmt(st, table_list_query);
    rs = OCI_GetResultset(st);

    while(OCI_FetchNext(rs)){
        int row = OCI_GetCurrentRow(rs)-1;
        qlisttbl_putstr(tbl, "row", OCI_GetString(rs,1));
        char* table_name = qlisttbl_getstr(tbl,"row",true);

        strncpy(config_info->extraction_target_list, table_name, TABLE_NAME_LEN);
    }
}
 */


TableInfo* WriteTableInfo(ConfigSet config_set, OCI_Connection* cn) {

    StrUpper(config_set.conn_info->username);
    char *table_list_query = MallocAllocation(TABLE_LIST_LEN);
    snprintf(table_list_query, TABLE_LIST_LEN, TABLE_LIST, config_set.conn_info->username);

    OCI_Statement *table_list_st = OCI_StatementCreate(cn);
    OCI_ExecuteStmtFmt(table_list_st, table_list_query);
    OCI_Resultset *table_list_rs = OCI_GetResultset(table_list_st);

    char table_list[MAX_TABLE_ROW_COUNT][TABLE_NAME_LEN] = {0,};

    while (OCI_FetchNext(table_list_rs)) {
        int index = OCI_GetCurrentRow(table_list_rs) - 1;
        row_count = OCI_GetRowCount(table_list_rs);
        strncpy(table_list[index], OCI_GetString(table_list_rs, 1), TABLE_NAME_LEN);
    }

    TableInfo* table_info = (TableInfo*) malloc(row_count * sizeof(TableInfo));
    int i =0;
    for (i = 0; i < row_count; i++) {
        memset(&table_info[i], 0x00, sizeof(TableInfo));

        strncpy(table_info[i].schema_name, config_set.conn_info->username, SCHEMA_NAME_LEN);
        strncpy(table_info[i].object_name, table_list[i], OBJECT_NAME_LEN);

        // object id
        OCI_Statement *object_id_st = OCI_StatementCreate(cn);
        char *object_id_query = MallocAllocation(QUERY_LEN);
        snprintf(object_id_query, QUERY_LEN, TABLE_INFO_OBJECT_ID, table_info[i].object_name);

        OCI_ExecuteStmtFmt(object_id_st, object_id_query);
        OCI_Resultset *object_id_rs = OCI_GetResultset(object_id_st);
        while (OCI_FetchNext(object_id_rs)){
            table_info[i].object_id = OCI_GetInt(object_id_rs,1);
        }

        char *table_info_query = MallocAllocation(NEW_TABLE_INFO_SIZE);
        snprintf(table_info_query, NEW_TABLE_INFO_SIZE, TABLE_INFO, config_set.conn_info->username, table_list[i]);

        OCI_Statement *table_info_st;
        OCI_Resultset *table_info_rs;

        table_info_st = OCI_StatementCreate(cn);
        OCI_ExecuteStmtFmt(table_info_st, table_info_query);
        table_info_rs = OCI_GetResultset(table_info_st);

        int column_row_count = 0;
        while (OCI_FetchNext(table_info_rs)) {
            column_row_count = OCI_GetRowCount(table_info_rs);
            table_info[i].columns_number = column_row_count;
            table_info[i].table_column_name = MallocAllocation(COLUMN_NAME_LEN * sizeof(unsigned char));
            table_info[i].table_column_type = MallocAllocation(COLUMN_TYPE_LEN * sizeof(unsigned char));
            table_info[i].table_column_nullable = MallocAllocation(COLUMN_NULLABLE_LEN * sizeof(unsigned char));

            memset(table_info[i].table_column_name, 0x00, COLUMN_NAME_LEN * sizeof(unsigned char));
            memset(table_info[i].table_column_type, 0x00, COLUMN_TYPE_LEN * sizeof(unsigned char));
            memset(table_info[i].table_column_nullable, 0x00, COLUMN_NULLABLE_LEN * sizeof(unsigned char));

            strncpy(table_info[i].table_column_name, OCI_GetString(table_info_rs, 1), COLUMN_NAME_LEN - 1);
            strncpy(table_info[i].table_column_type, OCI_GetString(table_info_rs, 2), COLUMN_TYPE_LEN - 1);
            strncpy(table_info[i].table_column_nullable, OCI_GetString(table_info_rs, 3), COLUMN_NULLABLE_LEN - 1);

            table_info[i].table_column_name[COLUMN_NAME_LEN - 1] = '\0';
            table_info[i].table_column_type[COLUMN_TYPE_LEN - 1] = '\0';
            table_info[i].table_column_nullable[COLUMN_NULLABLE_LEN - 1] = '\0';
        }
    }
    return table_info;
}


void FindLogFile(int start_initial, OCI_Connection* cn) {

    OCI_Statement *st = OCI_StatementCreate(cn);
    OCI_ExecuteStmtFmt(st, SELECT_CURRENT_LOGFILE);
    OCI_Resultset *rs = OCI_GetResultset(st);

    while (OCI_FetchNext(rs)) {
        printf("current log file : %s\n", OCI_GetString(rs, 1));

        if (start_initial == 1) {
            char *alter_logfile_init_query = MallocAllocation(QUERY_LEN);
            snprintf(alter_logfile_init_query, QUERY_LEN, LOGMNR_ADD_LOGFILE, OCI_GetString(rs, 1));

            OCI_Statement *alter_logfile_init_st = OCI_StatementCreate(cn);
            OCI_ExecuteStmtFmt(alter_logfile_init_st, alter_logfile_init_query);
            printf("alter log file init\n");

        } else {
            // log switch occur
            int current_sequence = 0;

            // current file sequence
            OCI_Statement *sequence_check_st = OCI_StatementCreate(cn);
            OCI_ExecuteStmtFmt(sequence_check_st, SEQUENCE_CHECK);
            OCI_Resultset *sequence_check_rs = OCI_GetResultset(sequence_check_st);
            while(OCI_FetchNext(sequence_check_rs)){
                current_sequence = OCI_GetInt(sequence_check_rs, 1);
                printf("current sequence : %d\n", current_sequence);
            }

            // find log file : between sequence#
            char *between_sequence_query = MallocAllocation(QUERY_LEN);
            snprintf(between_sequence_query, QUERY_LEN, BETWEEN_SEQUENCE_LOGFILE_LIST, before_sequence, current_sequence);

            OCI_Statement *between_sequence_st = OCI_StatementCreate(cn);
            OCI_ExecuteStmtFmt(between_sequence_st, between_sequence_query);
            OCI_Resultset *between_sequence_rs = OCI_GetResultset(between_sequence_st);

            while(OCI_FetchNext(between_sequence_rs)){
                // add log file
                char *add_between_logfile_query = MallocAllocation(QUERY_LEN);
                snprintf(add_between_logfile_query, QUERY_LEN, LOGMNR_ADD_LOGFILE, OCI_GetString(between_sequence_rs,1));
                printf("add between log file query : %s\n", add_between_logfile_query);

                OCI_Statement *add_between_logfile_st = OCI_StatementCreate(cn);
                OCI_ExecuteStmtFmt(add_between_logfile_st, add_between_logfile_query);
            }

            before_sequence = current_sequence;
            current_sequence = 0;

            // status : current log file add
            printf("\n ! log switch occur ! \n");
        }
    }

    OCI_Statement* start_logmnr_st = OCI_StatementCreate(cn);
    OCI_ExecuteStmtFmt(start_logmnr_st, LOGMNR_START);
    printf("start logminer session\n");
    start_initial = 0;

}

// extract process
void ExtractProcess(OCI_Connection* cn, TableInfo* table_info){
    printf("\n ! Extract Process Start !\n\n");

    // scn : find greater log file
    // table 별로 조회
    int i = 0;

    for (i=0;i<row_count;i++){
        printf("\n-----[TABLE : %s]-----\n",table_info[i].object_name);

        CheckPointInfo *check_point_info;
        char *check_point_query = MallocAllocation(QUERY_LEN);
        printf("check point info last read scn : %d\n", check_point_info->last_read_scn);

        snprintf(check_point_query, QUERY_LEN, FIND_ROW, check_point_info->last_read_scn, table_info[i].object_name);
        printf("check_point_query : %s\n", check_point_query);

        OCI_Statement *scn_row_st = OCI_StatementCreate(cn);
        OCI_ExecuteStmtFmt(scn_row_st, check_point_query);
        OCI_Resultset* scn_row_rs = OCI_GetResultset(scn_row_st);

        while(OCI_FetchNext(scn_row_rs)){
            printf("sequence# : %d\n", OCI_GetString(scn_row_rs,1));

            // sequence check
            if (before_sequence == OCI_GetString(scn_row_rs,1)){
                // table info test
                printf("checking table info...\n");

                // operation code check
                printf("operation code : %d\n", OCI_GetInt(scn_row_rs, 4));

            }else{
                printf("\n ! log switch : already log miner started. !\n\n");
            }

            // last read scn change
            check_point_info->last_read_scn = OCI_GetInt(scn_row_rs, 5);
            printf("change checkpoint info : %lld\n", check_point_info->last_read_scn);
        }



    }

    // sequence

}