#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include <unistd.h>
#include <pthread.h>
#include <signal.h>
#include <qlibc/containers/qlist.h>
#include <qlibc/containers/qlisttbl.h>

// LEN info
#define IP_LEN 16
#define PORT_LEN 6
#define DBNAME_LEN 15
#define USERNAME_LEN 15
#define PASSWORD_LEN 30
#define IP_PORT_LEN 50
#define PATH_LEN 200
#define TARGET_LEN 100
#define TARGET_LIST_SIZE 20
#define LOG_LEVEL_LEN 10
#define LOG_BACKUP_LEN 30
#define SCHEMA_NAME_LEN 30
#define OBJECT_NAME_LEN 30
#define COLUMN_NAME_LEN 30
#define COLUMN_TYPE_LEN 20
#define COLUMN_NULLABLE_LEN 5
#define TABLE_NAME_LEN 30
#define DML_TYPE_LEN 10
#define SQL_TYPE_LEN 10
#define REC_TYPE_LEN 10
#define CAP_TYPE_LEN 10
#define PARTITION_LEN 10
#define TIMESTAMP_LEN 15
#define REC_CONTINUE_LEN 5
#define SCN_LEN 20
#define TX_ID_LEN 13
#define TX_END_LEN 10
#define OSNAME_LEN 15
#define HOSTNAME_LEN 15
#define RELEASE_LEN 50
#define VERSION_LEN 50
#define ARCHITECTURE_LEN 30
#define TRC_TYPE_LEN 10
#define INSTANCE_NAME_LEN 40

// log_level
#define TRACE 1
#define DEBUG 2
#define INFO 3

// log_backup
#define NOT_BACKUP 1
#define ROTATE_BACKUP 2
#define DAILY_ROTATE_BACKUP 3

// table_info
#define NEW_TABLE_INFO_SIZE (strlen(TABLE_INFO) + USERNAME_LEN + 1)
#define TABLE_LIST_LEN (strlen(TABLE_LIST) + USERNAME_LEN + 1)
#define MAX_TABLE_ROW_COUNT 20
#define LOGFILE_LEN (PATH_LEN*2)
#define QUERY_LEN 256

// default
#define DEFAULT_LOG_PATH "/logs"
#define DEFAULT_TRACING_PATH "/trace"

// sql
#define SUPPLEMENTAL_LOG "SELECT SUPPLEMENTAL_LOG_DATA_ALL FROM V$DATABASE"
#define TABLE_LIST "SELECT TABLE_NAME FROM ALL_TABLES WHERE OWNER='%s'"
#define TABLE_INFO "SELECT COLUMN_NAME, DATA_TYPE, NULLABLE FROM ALL_TAB_COLUMNS WHERE OWNER='%s' AND TABLE_NAME='%s'"
#define TABLE_INFO_COLUMN_NUMBER "SELECT COUNT(*) FROM ALL_TAB_COLUMNS WHERE OWNER="
#define TABLE_INFO_OBJECT_ID "SELECT OBJECT_ID FROM USER_OBJECTS WHERE OBJECT_TYPE='TABLE' AND OBJECT_NAME='%s'"

#define SEQUENCE_CHECK "SELECT SEQUENCE# FROM V$LOG WHERE STATUS='CURRENT'"
#define SELECT_CURRENT_LOGFILE "SELECT MEMBER FROM V$LOGFILE WHERE GROUP#=(SELECT GROUP# FROM V$LOG WHERE STATUS='CURRENT')"
#define SELECT_GROUP_LOG_LIST "SELECT GROUP#, MEMBER FROM V$LOGFILE"
#define ALTER_LOGFILE_INIT "SELECT A.MEMBER FROM V$LOGFILE A JOIN V$LOG B ON A.GROUP# = B.GROUP# AND SEQUENCE# > 0"
#define ALTER_LOGFILE "ALTER DATABASE ADD LOGFILE GROUP%d %s SIZE 5M"
#define BETWEEN_SEQUENCE_LOGFILE_LIST "SELECT B.MEMBER FROM V$LOG A JOIN V$LOGFILE B ON A.GROUP# = B.GROUP# WHERE A.SEQUENCE# > %d AND A.SEQUENCE# < %d"
#define LOGMNR_CHECK "SELECT COUNT(*) FROM V$LOGMNR_SESSION"
#define LOGMNR_START "EXECUTE DBMS_LOGMNR.START_LOGMNR(OPTIONS=>DBMS_LOGMNR.DICT_FROM_REDO_LOGS); end;"
#define LOGMNR_END "EXECUTE DBMS_LOGMNR.END_LOGMNR(); end;"
#define LOGMNR_ADD_LOGFILE "EXECUTE DBMS_LOGMNR.ADD_LOGFILE(LOGFILENAME=>'%s', OPTIONS=>DBMS_LOGMNR.NEW); end;"
#define LOGMNR_EXTRACT "SELECT A.OPERATION,A.OPERATION_CODE,A.SEQUENCE#,A.SCN,A.TIMESTAMP,A.ROW_ID,A.SQL_REDO,B.OBJECT_NAME FROM V$LOGMNR_CONTENTS A LEFT JOIN ALL_OBJECTS B ON A.DATA_OBJ#=B.OBJECT_ID WHERE (A.OPERATION IN ('START','COMMIT','DML') OR B.OWNER='TEST')"

#define CURRENT_SCN "SELECT CURRENT_SCN FROM V$DATABASE"
#define FIND_ROW "SELECT SEQUENCE#, SEG_NAME, SQL_REDO, OPERATION_CODE, SCN FROM V$LOGMNR_CONTENTS WHERE SCN > %d AND TABLE_NAME='%s'"

qlisttbl_t table_list[TARGET_LIST_SIZE];
char* current_log_file;

// STRUCT info
typedef struct db_conn_info{
    char ip[IP_LEN];
    char port[PORT_LEN];
    char dbname[DBNAME_LEN];
    char username[USERNAME_LEN];
    char password[PASSWORD_LEN];
}DbConnInfo;

typedef struct config_info{
    char db_conn[PATH_LEN];
    char* extraction_schema;
    qlisttbl_t* extraction_target_list;
    char log_level[LOG_LEVEL_LEN];
    char log_backup[LOG_BACKUP_LEN];
    char log_path[PATH_LEN];
    char tracing_path[PATH_LEN];
}ConfigInfo;

typedef struct config_set{
    ConfigInfo* config_info;
    DbConnInfo* conn_info;
}ConfigSet;

typedef struct table_info{
    unsigned char schema_name[SCHEMA_NAME_LEN];
    unsigned char object_name[OBJECT_NAME_LEN];
    unsigned long object_id;
    unsigned long columns_number;
    unsigned char **table_column_name;
    unsigned char **table_column_type;
    unsigned char **table_column_nullable;
} TableInfo;


typedef struct dml_row_info{
    TableInfo table_info;
    unsigned char dml_type[DML_TYPE_LEN];
    char* sql_redo;
} DmlRowInfo;

typedef struct dml_info{
    char schema_name[SCHEMA_NAME_LEN];
    char object_name[OBJECT_NAME_LEN];
    unsigned char sql_type[SQL_TYPE_LEN];
    char* before;
    char* after;
    unsigned long commit_scn;
    unsigned long commit_indicator;
    char timestamp;
} DmlInfo;

typedef struct checkpoint_info{
    char last_read_tx[TX_ID_LEN];
    long long int last_read_scn;
    char last_write_tx[TX_ID_LEN];
    long long int last_write_scn;
} CheckPointInfo;

/*
typedef struct tracing_record{
    TracingRecordHeader header;
    TracingRecordTransaction transaction;
    void *data;
} TracingRecord;
*/

typedef struct tracing_record_header{
    unsigned char trc_record_type[REC_TYPE_LEN];
    unsigned char capture_type[CAP_TYPE_LEN];
    unsigned char partition[PARTITION_LEN];
    int data_bytes;
    unsigned char timestamp[TIMESTAMP_LEN];
    int thread;
    int record_sequence;
    int record_block;
    int record_offset;
    int tx_index;
    int tx_indicator;
    int record_columns;
    unsigned char record_continue[REC_CONTINUE_LEN];
    int definition_id;
    char* schema;
    char* object;
} TracingRecordHeader;


typedef struct tracing_record_transaction{
    long row_id;
    char commit_scn[SCN_LEN];
    char timestamp[TIMESTAMP_LEN];
    char tx_id[TX_ID_LEN];
    char tx_end[TX_END_LEN];
} TracingRecordTransaction;

/*
typedef struct tracing_file_header{
    TracingFileHeaderOs os;
    TracingFileHeaderDb db;
} TracingFileHeader;

typedef struct tracing_file_header_os{
    char osname[OSNAME_LEN];
    char hostname[HOSTNAME_LEN];
    char kernel_release[RELEASE_LEN];
    char kernel_version[VERSION_LEN];
    char architecture[ARCHITECTURE_LEN];
} TracingFileHeaderOs;

typedef struct tracing_file_header_db{
    char type[TRC_TYPE_LEN];
    char db_name[DBNAME_LEN];
    char instance_name[INSTANCE_NAME_LEN];
    char version[VERSION_LEN];
} TracingFileHeaderDb;
*/

