#include "modules/function.h"
#include "ocilibc/api.h"

void SigIntHandler();
void SigTermHandler();

int start_initial = 1;
extern int before_sequence;
extern int row_count;

int main(int argc, char* argv[]) {

    // signal
    signal(SIGINT,SigIntHandler);
    signal(SIGTERM, SigTermHandler);

    // db_connect - oci
    OCI_Connection* cn;

    // argument check
    if (argc!=2){
        printf("--Usage : extract <filename>.\n");
        return -1;
    }

    // arg - path
    char path[PATH_LEN] = {0,};
    strncpy(path, argv[1], PATH_LEN);

    // conn.conf file check
    struct config_set config_set;
    memset(&config_set,0, sizeof(ConfigSet));

    config_set.config_info = ConfigParser(path);
    if (config_set.config_info == NULL){
        printf("--Check : config option.\n");
        return -2;
    }
    config_set.conn_info = ConnectParser(config_set.config_info->db_conn);
    if (config_set.conn_info == NULL){
        printf("--Check : conn option.\n");
        return -2;
    }

    // db connect - ip
    char* ip_port = CreateIpPort(config_set.conn_info->ip, config_set.conn_info->port, config_set.conn_info->dbname);
    if (ip_port == NULL) {
        printf("Failed to create IP port.\n");
        return -3;
    }

    // db connect
    OCI_Initialize(NULL, NULL, OCI_ENV_DEFAULT);
    cn = OCI_ConnectionCreate(ip_port, config_set.conn_info->username, config_set.conn_info->password, OCI_SESSION_DEFAULT);
    if (cn == NULL){
        printf("---DB Connection Fail.\n");
        return EXIT_FAILURE;
    }
    // check supplemental logging
    bool checking = CheckSupplementalLog(cn);
    if (checking == false){
        printf("false\n");
        return -3;
    }

    // table info
    TableInfo* table_info;
    table_info = WriteTableInfo(config_set, cn);
    printf("\n ! Info Setting all finish ! \n\n");

    // find log file
    FindLogFile(start_initial, cn);

    // extract process start
    ExtractProcess(cn, table_info);

    printf("\nall processes done\n");

    OCI_ConnectionFree(cn);
    OCI_Cleanup();

    return EXIT_SUCCESS;

}

void SigIntHandler(){
    printf("[SIGINT] program end.\n");

}

void SigTermHandler(){
    printf("[SIGTERM] program end.\n");
}